<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Fondos de Anuncios de Películas</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;600&display=swap" rel="stylesheet"/>
  <style>
    body {
      margin: 0;
      padding: 0;
      font-family: 'Poppins', sans-serif;
      background-color: #0d0d0d;
      color: #9db0b57;
    }

    .container {
      display: flex;
      flex-direction: column;
      height: 100vh;
    }

    .banner {
      position: relative;
      flex: 1;
      background-size: cover;
      background-position: center;
      display: flex;
      align-items: flex-end;
      justify-content: flex-start;
      padding: 40px;
      transition: background-image 1s ease-in-out;
      overflow: hidden;
    }

    .banner::before {
      content: "";
      position: absolute;
      inset: 0;
      background: linear-gradient(to top, rgba(0, 0, 0, 0.85), rgba(0, 0, 0, 0.3));
      z-index: 0;
    }

    .banner-content {
      position: relative;
      z-index: 1;
      max-width: 60%;
      text-align: left;
    }

    .banner-title {
      font-size: 2.5rem;
      font-weight: 600;
      margin-bottom: 10px;
      color: transparent; /* Letras ocultas */
    }

    .banner-info {
      font-size: 1rem;
      font-weight: 300;
      line-height: 1.5;
      max-height: 4.5em;
      overflow: hidden;
      color: transparent; /* Letras ocultas */
    }

    .carousel {
      position: absolute;
      top: 55%;
      left: 20%;
      height: 180px;
      width: 78%;
      overflow: hidden;
      background-color: rgba(0, 0, 0, 0.6);
      border-radius: 16px;
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.7);
      z-index: 2;
    }

    .carousel-inner {
      display: flex;
      gap: 15px;
      animation: scroll 40s linear infinite;
      width: max-content;
    }

    .carousel-inner img {
      height: 180px;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.6);
      cursor: pointer;
      transition: transform 0.3s;
    }

    .carousel-inner img:hover {
      transform: scale(1.1);
    }

    @keyframes scroll {
      0% {
        transform: translateX(0);
      }
      100% {
        transform: translateX(-50%);
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="banner">
      <div class="banner-content">
        <h1 class="banner-title">Título de la Película</h1>
        <p class="banner-info">Información breve sobre la película.</p>
      </div>
      <div class="carousel">
        <div class="carousel-inner" id="carousel-inner">
          <!-- Pósters se cargarán aquí -->
        </div>
      </div>
    </div>
  </div>

  <script>
    const API_KEY = '6b8e3eaa1a03ebb45642e9531d8a76d2';
    const BASE_URL = 'https://api.themoviedb.org/3';
    const BANNER = document.querySelector('.banner');
    const CAROUSEL_INNER = document.getElementById('carousel-inner');

    let currentMovieIndex = 0;

    async function fetchMovies() {
      try {
        const response = await fetch(`${BASE_URL}/movie/popular?api_key=${API_KEY}&language=es&page=1`);
        const data = await response.json();
        return data.results;
      } catch (error) {
        console.error('Error al obtener películas:', error);
      }
    }

    function updateBanner(movie) {
      BANNER.style.backgroundImage = `url(https://image.tmdb.org/t/p/original${movie.backdrop_path})`;
      BANNER.querySelector('.banner-title').textContent = movie.title;
      BANNER.querySelector('.banner-info').textContent = movie.overview.substring(0, 150) + '...';
    }

    function startBannerRotation(movies) {
      setInterval(() => {
        currentMovieIndex = (currentMovieIndex + 1) % movies.length;
        updateBanner(movies[currentMovieIndex]);
      }, 8000);
    }

    function updateCarousel(movies) {
      CAROUSEL_INNER.innerHTML = '';
      const posters = [...movies, ...movies];
      posters.forEach(movie => {
        const poster = document.createElement('img');
        poster.src = `https://image.tmdb.org/t/p/w500${movie.poster_path}`;
        poster.alt = movie.title;
        poster.addEventListener('click', () => updateBanner(movie));
        CAROUSEL_INNER.appendChild(poster);
      });
    }

    async function init() {
      const movies = await fetchMovies();
      if (movies && movies.length > 0) {
        updateBanner(movies[0]);
        startBannerRotation(movies);
        updateCarousel(movies);
      }
    }

    init();
  </script>
</body>
</html>
