<?php
session_start();

define('TMDB_API_KEY', '6b8e3eaa1a03ebb45642e9531d8a76d2');
define('TMDB_API_URL', 'https://api.themoviedb.org/3');
define('TMDB_IMG_URL', 'https://image.tmdb.org/t/p/');

function tmdbRequest($endpoint, $params = []) {
    $params['api_key'] = TMDB_API_KEY;
    $params['language'] = 'en-US';
    $url = TMDB_API_URL . $endpoint . '?' . http_build_query($params);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

$trendingMovies = tmdbRequest('/trending/movie/week');
$movies = [];

foreach (($trendingMovies['results'] ?? []) as $movie) {
    if (!empty($movie['backdrop_path']) && !empty($movie['poster_path'])) {
        $movieDetails = tmdbRequest('/movie/' . $movie['id']);
        
        $movies[] = [
            'id' => $movie['id'],
            'title' => $movie['title'],
            'original_title' => $movie['original_title'],
            'overview' => $movie['overview'],
            'year' => substr($movie['release_date'] ?? '', 0, 4),
            'backdrop_path' => TMDB_IMG_URL . 'original' . $movie['backdrop_path'],
            'poster_path' => TMDB_IMG_URL . 'w500' . $movie['poster_path'],
            'rating' => $movie['vote_average'],
            'runtime' => $movieDetails['runtime'] ?? 0,
            'genres' => array_map(function($genre) {
                return $genre['name'];
            }, $movieDetails['genres'] ?? [])
        ];
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cinema Experience</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
    <style>
        @keyframes textGlow {
            0%, 100% { text-shadow: 0 0 15px rgba(255,255,255,0.1); }
            50% { text-shadow: 0 0 25px rgba(255,255,255,0.3); }
        }
        
        @keyframes gradientMove {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        body {
            margin: 0;
            padding: 0;
            background: #000;
            color: white;
            overflow: hidden;
            font-family: 'Helvetica Neue', sans-serif;
        }
        
        .cinema-container {
            position: fixed;
            width: 100vw;
            height: 100vh;
            background: #000;
        }

        .slide {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 1.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .slide.active {
            opacity: 1;
        }

        .backdrop {
            position: absolute;
            width: 100%;
            height: 100%;
            background-size: cover;
            background-position: center;
            transform: scale(1.1);
            transition: transform 4.5s linear;
        }

        .slide.active .backdrop {
            transform: scale(1);
        }

        .content-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(
                90deg,
                rgba(0,0,0,0.9) 0%,
                rgba(0,0,0,0.7) 30%,
                rgba(0,0,0,0.4) 60%,
                rgba(0,0,0,0.2) 100%
            );
            display: flex;
            align-items: flex-start; /* Alinear al inicio (arriba) */
        }

        .movie-content {
            width: 100%;
            max-width: 1000px; /* Aumentado de 700px */
            margin: 0;
            padding: 3rem 4rem; /* Ajustado para colocarlo en la parte superior */
            display: flex;
            justify-content: space-between; /* Espaciado entre info y póster */
            align-items: flex-start; /* Alinear al inicio (arriba) */
            gap: 3rem; /* Aumentado de 2rem */
            opacity: 0;
            transform: translateY(15px);
            transition: all 1s ease 0.3s;
        }

        .slide.active .movie-content {
            opacity: 1;
            transform: translateY(0);
        }

        .movie-info {
            flex: 1;
        }

        .movie-title {
            font-size: 3.5rem; /* Aumentado de 2.5rem */
            font-weight: 800;
            line-height: 1.1;
            margin-bottom: 0.75rem; /* Aumentado de 0.5rem */
            background: linear-gradient(90deg, #fff, #e2e2e2);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            animation: textGlow 3s ease-in-out infinite;
        }

        .original-title {
            font-size: 1.1rem; /* Aumentado de 0.75rem */
            color: #aaa;
            margin-bottom: 1.5rem; /* Aumentado de 1rem */
        }

        .movie-stats {
            display: flex;
            gap: 1.5rem; /* Aumentado de 1rem */
            margin-bottom: 1.5rem; /* Aumentado de 1rem */
            font-size: 1rem; /* Aumentado de 0.625rem */
        }

        .rating {
            color: #ffd700;
            font-weight: bold;
        }

        .genre-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 0.5rem; /* Aumentado de 0.375rem */
            margin-bottom: 1.5rem; /* Aumentado de 1rem */
        }

        .genre-tag {
            padding: 0.35rem 1rem; /* Aumentado de 0.25rem 0.75rem */
            border-radius: 30px; /* Aumentado de 25px */
            background: linear-gradient(90deg, rgba(255,255,255,0.2), rgba(255,255,255,0.1));
            backdrop-filter: blur(5px);
            font-size: 0.65rem; /* Aumentado de 0.45rem */
            letter-spacing: 0.7px; /* Aumentado de 0.5px */
            text-transform: uppercase;
        }

        .overview {
            font-size: 0.85rem; /* Aumentado de 0.55rem */
            line-height: 1.7;
            color: #ddd;
            max-width: 450px; /* Aumentado de 300px */
        }

        .poster-container {
            position: relative;
            width: 250px; /* Aumentado de 190px */
            perspective: 800px; /* Aumentado de 500px */
            flex-shrink: 0; /* Evita que el póster se encoja */
        }

        .poster {
            width: 100%;
            border-radius: 15px; /* Aumentado de 10px */
            box-shadow: 0 15px 30px rgba(0,0,0,0.4); /* Aumentado de 0 10px 20px */
            transform: rotateY(-15deg) translateZ(0);
            transition: transform 0.5s ease;
        }

        .poster:hover {
            transform: rotateY(0) translateZ(25px); /* Reducido a la mitad de 50px */
        }

        .progress-container {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 2px; /* Reducido a la mitad de 4px */
            background: rgba(255,255,255,0.1);
        }

        .progress-bar {
            height: 100%;
            width: 0;
            background: linear-gradient(90deg, #fff, #ffd700);
            background-size: 200% 100%;
            animation: gradientMove 2s linear infinite;
            transition: width 4.5s linear;
        }

        .slide.active .progress-bar {
            width: 100%;
        }

        .slide-number {
            position: fixed;
            right: 1rem; /* Reducido a la mitad de 2rem */
            top: 1rem; /* Reducido a la mitad de 2rem */
            font-size: 0.75rem; /* Reducido a la mitad de 1.5rem */
            font-weight: bold;
            color: rgba(255,255,255,0.5);
        }
    </style>
</head>
<body>
    <div class="cinema-container">
        <div class="slide-number">
            <span id="currentSlide">1</span>/<span id="totalSlides"><?php echo count($movies); ?></span>
        </div>
        
        <?php foreach ($movies as $index => $movie): ?>
        <div class="slide <?php echo $index === 0 ? 'active' : ''; ?>">
            <div class="backdrop" style="background-image: url('<?php echo $movie['backdrop_path']; ?>')"></div>
            <div class="content-overlay">
                <div class="movie-content">
                    <div class="movie-info">
                        <h1 class="movie-title"><?php echo $movie['title']; ?></h1>
                        <div class="original-title"><?php echo $movie['original_title']; ?></div>
                        
                        <div class="movie-stats">
                            <span><?php echo $movie['year']; ?></span>
                            <span><?php echo $movie['runtime']; ?> min</span>
                            <span class="rating">★ <?php echo number_format($movie['rating'], 1); ?></span>
                        </div>
                        
                        <div class="genre-tags">
                            <?php foreach ($movie['genres'] as $genre): ?>
                                <span class="genre-tag"><?php echo $genre; ?></span>
                            <?php endforeach; ?>
                        </div>
                        
                        <p class="overview"><?php echo $movie['overview']; ?></p>
                    </div>
                    
                    <div class="poster-container">
                        <img src="<?php echo $movie['poster_path']; ?>" class="poster" alt="<?php echo $movie['title']; ?>">
                    </div>
                </div>
            </div>
            <div class="progress-container">
                <div class="progress-bar"></div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <script>
    const slides = document.querySelectorAll('.slide');
    const currentSlideElement = document.getElementById('currentSlide');
    let currentSlide = 0;
    const interval = 4500;

    function showSlide(index) {
        slides.forEach(slide => {
            slide.classList.remove('active');
        });
        
        slides[index].classList.add('active');
        currentSlideElement.textContent = index + 1;
    }

    function nextSlide() {
        currentSlide = (currentSlide + 1) % slides.length;
        showSlide(currentSlide);
    }

    setInterval(nextSlide, interval);
    </script>
</body>
</html>